/*
	File:		BevelButtonItems.h

	Contains:	Constants for our CDEF Tester

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(MAA)	Matt Ackeret
		(edv)	Ed Voas

	Change History (most recent first):

	uality5>	 11/5/97	MAA		Add tab dialog info
		 <4>	10/28/97	MAA		Add items back in from cancelled checkout
		 <3>	10/28/97	edv		Use RadioGroup control!
		 <2>	 10/8/97	MAA		Add items for CreateEditText dialog
		 <1>	 9/11/97	edv		First checked in.
*/

// Bevel Buttons

enum
{
	kBevelSizePopup			= 1,
	kBevelBehaviorPopup		= 3,
	kBevelOffsetCheck		= 4,
	
	kBevelMenuIDText		= 7,
	kBevelMultiMenuCheck	= 8,
	kBevelMenuOnRightCheck	= 9,
	
	kBevelContentPopup		= 11,
	kBevelContentIDText		= 13,
	
	kBevelGraphicAlignPopup	= 15,
	kBevelGraphicHOffsetText= 18,
	kBevelGraphicVOffsetText= 20,
	
	kBevelTextAlignPopup	= 22,
	kBevelTextOffsetText	= 24,
	kBevelTextPlacePopup	= 25,
	
	kBevelHeightText		= 27,
	kBevelWidthText			= 29,
	kBevelTitleText			= 30,

	kBevelCancelButton		= 32,
	kBevelOKButton			= 33
};

// Dividers

enum 
{
	kHorizontalRadio		= 6,
	kVerticalRadio			= 7,
	kLengthText				= 2,
	kDividerCancelButton	= 3,
	kDividerOKButton		= 4,
	kDividerRadioGroup		= 5
};

// Disclosure Triangles

enum
{
	kLeftFacingCheck		= 1,
	kAutoTrackCheck			= 2,
	kTriangleCancelButton	= 3,
	kTriangleOKButton		= 4
};

// Edit Text
enum
{
	kETOKButton				= 1,
	kETCancelButton			= 2,
	kETPasswordCheck		= 3
};

// Static Text
enum
{
	kSTOKButton				= 1,
	kSTCancelButton			= 2
};


// Slider
enum
{
	kSliderNonDirectional	= 3,
	kSliderDirectional		= 4,
	kSliderTickMarks		= 5,
	kSliderReverse			= 6
};
	
// Clock
enum
{
	kClockTime				= 3,
	kClockTimeSeconds		= 4,
	kClockDate				= 5,
	kClockMonthYear			= 6
};


// Finder Header

enum
{
	kFHHeightText			= 3,
	kFHWidthText			= 4,
	kFHListViewCheck		= 5,
	kFHCancelButton			= 6,
	kFHOKButton				= 7
};

// Icon/Picture

enum
{
	kIconResIDText			= 2,
	kIconOK					= 3,
	kIconCancel				= 4,
	kIconNoHitCheck			= 5,
	kIconHeightLabelText	= 6,
	kIconWidthLabelText		= 7,
	kIconHeightText			= 8,
	kIconWidthText			= 9,
	kIconUseRectCheck		= 10
};

// Progress Bar

enum
{
	kProgLengthText			= 2,
	kProgOKButton			= 3,
	kProgCancelButton		= 4,
	kProgIndeterminateCheck	= 5
};

// Group Box

enum
{
	kGroupOKButton			= 1,
	kGroupCancelButton		= 2,
	kGroupRadioGroup		= 3,
	kGroupPrimaryRadio		= 4,
	kGroupSecondaryRadio	= 5,
	kGroupHeightText		= 8,
	kGroupWidthText			= 9,
	kGroupVariantPopup		= 10,
	kGroupTitleText			= 12,
	kGroupMenuIDText		= 13,
	kGroupMenuIDLabelText	= 14
};

// Placard

enum
{
	kPlacardHeightText		= 3,
	kPlacardWidthText		= 4,
	kPlacardOKButton		= 5,
	kPlacardCancelButton	= 6
};

// Popup Arrow

enum
{
	kPopArrowDirPopup		= 1,
	kPopArrowSmallCheck		= 2,
	kPopArrowOKButton		= 3,
	kPopArrowCancelButton	= 4
};

// Scroll Bars

enum 
{
	kScrollRadioGroup		= 1,
	kScrollHorizontalRadio	= 2,
	kScrollVerticalRadio	= 3,
	kScrollLengthText		= 5,
	kScrollCancelButton		= 6,
	kScrollOKButton			= 7
};

// Image Well

enum
{
	kImageContentPopup		= 1,
	kImageResIDText			= 3,
	kImageOKButton			= 4,
	kImageCancelButton		= 5,
	kImageHeightText		= 8,
	kImageWidthText			= 9
};

// Tabs
enum
{
	kTabUseIcon				= 3,
	kTabNumberTabs			= 5,
	kTabSizeGroup			= 6,
	kTabDirectionGroup		= 7
};
	

enum
{
	kPushButtonOKButton		= 1,
	kPushButtonCancelButton	= 2,
	kPushButtonTitleText	= 4,
	kPushButtonDefaultCheck	= 5
};

enum
{
	kCheckBoxOKButton		= 1,
	kCheckBoxCancelButton	= 2,
	kCheckBoxTitleText		= 4
};

